﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="VIRP_WEB.Controls.Custom.EFR.FragLabResult" Codebehind="FragLabResult.ascx.cs" %>

<link href="<%: ResolveUrl("~/Content/Custom/EFR/EFR_Legacy_Modified.css") %>" rel="stylesheet" />

<style type="text/css">
    .style1
    {
        width: 8%;
    }
    .style2
    {
        width: 25%;
    }
    .style3
    {
        width: 328px;
    }
</style>

<asp:Panel ID="PanelPatient" runat="server" GroupingText="Patient Information&nbsp;&nbsp;">
    <table  summary="Table is used for layout purposes">
        <tr>
            <td>
                <asp:Label ID="LabelforFullNameLabel" runat="server" SkinID = "DataLabel">Full Name: 
                </asp:Label>
            </td>
            <td>
                <asp:Label ID="lblFullName" runat="server" SkinID = "DataLabel" />
                <asp:HyperLink runat="server" ID= "patientWorkflowsLink" ></asp:HyperLink>
            </td>
            <td>
                <asp:Label ID="LabelforLabelICN" runat="server" 
                    AssociatedControlID="lblICN" SkinID = "DataLabel">ICN:
                </asp:Label>
            </td>
            <td>
                <asp:Label ID="lblICN" runat="server" SkinID = "DataLabel" />
            </td>
        </tr>
        <tr>
            <td class="style1" >
                <asp:Label ID="LabelforSSNLabel" runat="server" 
                AssociatedControlID="lblSnum" SkinID = "DataLabel">SSN:</asp:Label>
            </td>
            <td class="style2" >
                <asp:Label ID="lblSnum" runat="server" SkinID = "DataLabel" />
            </td>
            <td class="style1" >
                <asp:Label ID="LabelforSTD_GENDER_IDLabel" runat="server" 
                    AssociatedControlID="lblGender" SkinID = "DataLabel">Gender:</asp:Label>
            </td>
            <td class="style2" >
                <asp:Label ID="lblGender" runat="server" SkinID = "DataLabel"></asp:Label>
            </td>
        </tr>
        <tr>
            <td class="style1" >
                <asp:Label ID="LabelforBIRTH_DATE_TEXTLabel" runat="server" 
                    AssociatedControlID="lblBirthday" SkinID = "DataLabel">Birth Date:</asp:Label>
            </td>
            <td class="style2" >
                <asp:Label ID="lblBirthday" runat="server" SkinID = "DataLabel" />
            </td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
        </tr>
    </table>
</asp:Panel>

<br />

<asp:Panel ID="PanelResultDetails" runat="server" GroupingText="Lab Report Details&nbsp;&nbsp;" >
    <table  
        summary="Table is used for layout purposes" 
        style="width: 800px">
            <tr>
                <td class="style1">
                    <asp:Label ID="Label3" runat="server" AssociatedControlID="txtLabRptDate" SkinID = "DataLabel">Metals Lab Report Date:</asp:Label>
                </td>
                <td class="style2" >
                    <asp:Label ID="txtLabRptDate" runat="server" MaxLength="10" Width="100px" SkinID = "DataLabel"></asp:Label>
                </td>
                <td class="style1" >
                    <asp:Label ID="Label2" runat="server" 
                        AssociatedControlID="txtAccession" SkinID = "DataLabel">Accession Number:</asp:Label>
                </td>
                <td class="style2" >
                      <asp:Label ID="txtAccession" runat="server" Width="100px" SkinID = "DataLabel"></asp:Label>
                </td>
            </tr>
            <tr>
                <td class="style1">
                    <asp:Label ID="Label5" runat="server" AssociatedControlID="txtLabCd" SkinID = "DataLabel">Lab Code:</asp:Label>
                </td>
                <td class="style2">
                    <asp:Label ID="txtLabCd" runat="server" Width="100px" SkinID = "DataLabel"/>
                </td>
                <td class="style1">
                    <asp:Label ID="Label7" runat="server" AssociatedControlID="txtLabID" SkinID = "DataLabel">Lab ID:</asp:Label>
                </td>
                <td class="style2">
                    <asp:Label ID="txtLabID" runat="server" Width="100px" SkinID = "DataLabel"/>
                </td>
                
            </tr>
            <tr>
                <td class="style1" >
                    <asp:Label ID="Label4" runat="server" AssociatedControlID="txtFragProdEventDate" SkinID = "DataLabel">Producing Event Date:</asp:Label>
                </td>
                <td class="style2">
                     <asp:Label ID="txtFragProdEventDate" runat="server" Width="100px" SkinID = "DataLabel"/>
                </td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
            </tr>
        </table>
</asp:Panel>
<br />

<asp:Panel ID="PanelFragmentData" runat="server" GroupingText="Fragment Data&nbsp;&nbsp;" >
    
    <asp:GridView ID="GridViewEFRFragments" 
        runat="server"         
        OnRowCommand="Fragments_RowCommand" 
        AutoGenerateColumns="false"
        AllowPaging="True" 
        PageSize="20" 
        DataKeyNames="FRAGMENT_ANALYSIS_ID"  
        AllowSorting="true"
        SkinID="Unsortable"
        cssClass="gridRegistry" 
        PagerStyle-CssClass="pager" 
        EmptyDataRowStyle-CssClass="gridRegistryEmpty">

        <EmptyDataTemplate>
            No fragments found for this lab result 
        </EmptyDataTemplate>                     
        <Columns>
            <asp:TemplateField AccessibleHeaderText = "Fragment ID" HeaderText = "Fragment ID" >
                <ItemTemplate>
                     <asp:Label SkinID="DataLabel" ID = "LabelFragmentID" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("FRAGMENT_ID_NUMBER"))) %>' /> 
                                
                </ItemTemplate>
             </asp:TemplateField>
             
             <asp:TemplateField AccessibleHeaderText = "Description" HeaderText = "Description">    
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelFragmentDescription" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("FRAGMENT_DESCR"))) %>' />
                              
                </ItemTemplate> 
             </asp:TemplateField>    
                
             <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" AccessibleHeaderText = "Select"  />
                        
        </Columns> 
    
        </asp:GridView> 
    
</asp:Panel>
<br />

